<?php
$cookie_email = !empty(get_cookie("a_cookie_email")) ? encrypt_decode(get_cookie("a_cookie_email")) : "";
$cookie_pass  = !empty(get_cookie("a_cookie_pass")) ? encrypt_decode(get_cookie("a_cookie_pass")) : "";
$redirect     = session('ref_url') ?? admin_url();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Admin Login - <?= site_config("site_title") ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">

<style>
*{box-sizing:border-box}
body{
  margin:0;
  font-family:'Poppins',sans-serif;
  min-height:100vh;
  background:#0f172a;
  display:flex;
  align-items:center;
  justify-content:center;
  color:#fff;
  overflow:hidden;
}

/* PARTICLE */
#particle-canvas{
  position:fixed;
  inset:0;
  z-index:0;
  pointer-events:none;
}

/* GLOW */
.bg{
  position:fixed;
  inset:0;
  background:
    radial-gradient(circle at 20% 30%, rgba(99,102,241,.25), transparent 40%),
    radial-gradient(circle at 80% 70%, rgba(56,189,248,.2), transparent 40%);
  z-index:0;
}

/* LOGIN BOX */
.login-box{
  position:relative;
  z-index:1;
  width:100%;
  max-width:420px;
  background:rgba(255,255,255,.08);
  backdrop-filter:blur(18px);
  border-radius:18px;
  padding:38px 34px;
  box-shadow:0 40px 90px rgba(0,0,0,.45);
}

/* HEADER */
.login-header{
  text-align:center;
  margin-bottom:28px;
}
.login-header img{
  height:46px;
  margin-bottom:10px;
}
.login-header h2{
  margin:0;
  font-size:22px;
  font-weight:600;
}
.login-header p{
  font-size:13px;
  opacity:.75;
}

/* INPUT */
.input{
  width:100%;
  height:46px;
  border-radius:12px;
  border:none;
  padding:0 14px;
  margin-bottom:14px;
  background:rgba(255,255,255,.15);
  color:#fff;
}
.input::placeholder{color:#cbd5f5}
.input:focus{
  outline:none;
  box-shadow:0 0 0 3px rgba(99,102,241,.5);
}

/* PASSWORD EYE */
.password-wrap{
  position:relative;
}
.eye{
  position:absolute;
  right:14px;
  top:50%;
  transform:translateY(-50%);
  cursor:pointer;
  font-size:18px;
  opacity:.8;
}

/* OPTIONS */
.options{
  display:flex;
  justify-content:space-between;
  align-items:center;
  font-size:13px;
  margin:6px 0 14px;
}
.options a{
  color:#a5b4fc;
  text-decoration:none;
}

/* BUTTON */
button{
  width:100%;
  height:46px;
  border:none;
  border-radius:12px;
  background:#6366f1;
  color:#fff;
  font-weight:600;
  cursor:pointer;
  transition:.25s;
}
button:hover{
  transform:translateY(-2px);
  background:#4f46e5;
}

/* FOOTER */
.footer{
  margin-top:18px;
  text-align:center;
  font-size:12px;
  opacity:.7;
}

/* MOBILE */
@media(max-width:480px){
  .login-box{padding:28px 22px;}
}
</style>
</head>

<body>

<div class="bg"></div>
<canvas id="particle-canvas"></canvas>

<div class="login-box">

  <div class="login-header">
    <img src="<?= get_logo() ?>" alt="Admin">
    <h2>Admin Sign In</h2>
    <p>Secure access to administration panel</p>
  </div>

  <?= form_open(
    url_to('admin.attempt_signin'),
    'class="actionForm" data-redirect="'.$redirect.'"'
  ) ?>

    <input class="input" type="email" name="email"
      placeholder="Admin Email"
      value="<?= $cookie_email ?: set_value('email') ?>"
      required autofocus>

    <div class="password-wrap">
      <input class="input" type="password" name="password" id="password"
        placeholder="Password"
        value="<?= $cookie_pass ?: set_value('password') ?>"
        required>
      <span class="eye" id="togglePass">👁️</span>
    </div>

    <div class="options">
      <label>
        <input type="checkbox" name="remember"
        <?= !empty($cookie_email) ? 'checked' : '' ?>>
        Remember me
      </label>
      <a href="<?= base_url('password-reset') ?>">Forgot?</a>
    </div>

    <button type="submit">LOGIN</button>

  <?= form_close(); ?>

  <div class="footer">
    © <?= date('Y') ?> <?= site_config('site_name') ?> • Admin Panel
  </div>

</div>

<script>
/* ===== SPIDER WEB PARTICLE EFFECT ===== */
const canvas = document.getElementById("particle-canvas");
const ctx = canvas.getContext("2d");
let w,h,particles=[];

function resize(){
  w = canvas.width = window.innerWidth;
  h = canvas.height = window.innerHeight;
}
resize();
window.addEventListener("resize", resize);

function add(x,y){
  particles.push({x,y,life:80});
}

window.addEventListener("mousemove",e=>add(e.clientX,e.clientY));
window.addEventListener("touchmove",e=>{
  const t=e.touches[0];
  add(t.clientX,t.clientY);
});
window.addEventListener("scroll",()=>{
  add(Math.random()*w,Math.random()*h);
});

function draw(){
  ctx.clearRect(0,0,w,h);
  particles.forEach((p,i)=>{
    p.life--;
    particles.slice(i+1).forEach(q=>{
      const d=Math.hypot(p.x-q.x,p.y-q.y);
      if(d<120){
        ctx.strokeStyle=`rgba(99,102,241,${0.15*(1-d/120)})`;
        ctx.beginPath();
        ctx.moveTo(p.x,p.y);
        ctx.lineTo(q.x,q.y);
        ctx.stroke();
      }
    });
  });
  particles=particles.filter(p=>p.life>0);
  requestAnimationFrame(draw);
}
draw();

/* PASSWORD TOGGLE */
const pass=document.getElementById("password");
const eye=document.getElementById("togglePass");
eye.onclick=()=>{
  if(pass.type==="password"){
    pass.type="text";eye.textContent="🙈";
  }else{
    pass.type="password";eye.textContent="👁️";
  }
};
</script>

</body>
</html>
